import React , {useState , useContext} from "react";
import "./App.css";
import Cameras from "./components/Cameras";
import ImuGps from "./components/ImuGps";
import {  useEffect } from "react";
import DebugList from"./components/DebugList";
import GeneralStatus from "./components/GeneralStatus";
import DeviceStart from "./components/DeviceStart";
import socketClient   from "socket.io-client"
import {AutoSizer} from 'react-virtualized';
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import {faPause, faPlay} from "@fortawesome/free-solid-svg-icons";
import Axios from "axios";
import {StatusContext} from './shared/status-context';

const socket = socketClient(process.env.REACT_APP_SOCKET_URL,{transports:['websocket']});
// const socket = socketClient(process.env.REACT_APP_SOCKET_URL);
function App() {
  const [status , setStatus] = useState({datasetName : "0000-00-00_000000" , captureStatus : "off" , deviceStatus : "off"});


  const [pauseMessages, setPauseMessages] = useState(false);
  useEffect(() => {
    socket.on("connection_start", (res) => {
      console.log("&&&&&&&&&&&&&***********************");
      Axios({
        method: "GET",
        withCredentials: true,
        url: process.env.REACT_APP_BACKEND_URL + "/Device/status",
      }).then(async (res) => {
        console.log("&&&&&&&&&&&&&&1");
        console.log(res.data);
        setStatus({ datasetName : res.data.datasetName , captureStatus : res.data.captureStatus , deviceStatus : res.data.deviceStatus })
        // update dataset name
  
      }).catch((er)=> console.log(er));
      console.log("&&&&&&&&&&&&&&2");
    //  console.log(res);
    })

    socket.on("connect_error", (err) => {
      console.log(`connect_error due to ${err.message}`);
    });
  }, []);

const onPauseMessages =() =>{
  setPauseMessages(!pauseMessages)
}
  return (
    
    <div className="App pt-3">
      <h4>Backpack GUI</h4>
      <div className=" m-2 py-1 border border-dark  rounded">
        <Cameras  socket={socket} />
        <ImuGps socket={socket} />
        <DeviceStart status={status}/>
      </div>
      <div className=" m-2 py-1 border border-dark  rounded">
        <GeneralStatus socket={socket} status={status} />
      </div>
      <div className=" m-2 px-2 border border-dark  rounded fill-height text-left relative ">
        <button className="btn btn-light btn-sm fixed-tr" onClick={onPauseMessages} > 
        <FontAwesomeIcon icon={ pauseMessages ? faPlay : faPause } className="menu-icon " />
        </button>
      <AutoSizer>
      {({ width, height }) => (
      <DebugList socket={socket} pause={pauseMessages} width={width} height={height} ></DebugList>
      )}
      </AutoSizer>
      </div>
    </div>

  );
}

export default App;
