import React from "react";
import { List } from "react-virtualized";
import { v4 as uuidv4 } from "uuid";
import { AutoSizer } from "react-virtualized";
class Imu extends React.Component {
  state = {
    data: [],
  };

  constructor(props) {
    super(props);
    this.state = {
      data: [{x:0,y:0,z:0}],
    };
  }

  componentDidMount() {
    this.props.socket.on("ImuData", (res) => {
      let mydata = [res];
      this.setState({ data: mydata });
      // this.state.data=[]
    });
  }



  render() {
    const height = this.props.height;
    const rowHeight = this.props.height;
    const width = this.props.width;
    return (
      <div
        className={
          "border p-1 rounded pb-3 border-2  " +
          (true ? "border-success " : "border-danger")
        }
      >
        <h6>IMU</h6>

        <div>
          <div className="col-4 float-left text-right bold">X :</div>
          <span>{this.state.data[0].x.toFixed(2)}</span>
        </div>
        <div>
          <div className="col-4 float-left text-right bold">Y :</div>
          <span>{this.state.data[0].y.toFixed(2)}</span>
        </div>
        <div>
          <div className="col-4 float-left text-right bold">Z :</div>
          <span>{this.state.data[0].z.toFixed(2)}</span>
        </div>


      </div>
    );
  }
}
export default Imu;
