import React from "react";
import Camera from "./UIElements/Camera";
import Axios from "axios";
import { useEffect, useState } from "react";

const Cameras = ({socket}) => {
  const [cameraData, setCameraData] = useState([]);
  const [newCameraData, setNewCameraData] = useState([]);

  socket.on("cameraData", (res) => {
    console.log(res);
    setCameraData(res);

  })
  // useEffect(() => {
  //   Axios({
  //     method: "GET",
  //     withCredentials: true,
  //     url: process.env.REACT_APP_BACKEND_URL + "/cameraInfo",
  //   }).then(async (res) => {
  //     console.log("********************");
  //     setCameraData(res.data);
  //     console.log(res.data);
  //   });
  // }, [newCameraData]);
  return (
    <React.Fragment>
      <div className="row  m-1 py-1">
        {(cameraData || []).map((cam) => (
          <div className="col-3 px-1" key={`divCamera_${cam.name}`}>
            <Camera
              bat={cam.bat}
              sd={cam.sd}
              name={cam.name}
              connection={cam.connection}
              recording={cam.recording}
              key={`cameraCom_${cam.name}`}
            ></Camera>
          </div>
        ))}
      </div>
    </React.Fragment>
  );
};
export default Cameras;
