import React, { useState } from "react";
import Axios from "axios";

const GeneralStatus = () => {
  const [newDatasetBtn, setNewDatasetBtn] = useState(true);
  const [captueBtn, setCaptureBtn] = useState("Start Capture");
  const [gpsBtn, setGpsBtn] = useState("Start Gps");  
  const [imuBtn, setImuBtn] = useState("Start Imu");    
  const [datasetName, setDatasetName] = useState("dataset 1"); 

  const onNewDataSet = () => {
    Axios({
      method: "GET",
      withCredentials: true,
      url: process.env.REACT_APP_BACKEND_URL + "/dataset/start",
    }).then(async (res) => {
      console.log("********************");
      // update dataset name
      setDatasetName(res)
    });

    setNewDatasetBtn(false);
  };

  const onCaptureBtnClick = () => {
    Axios({
      method: "GET",
      withCredentials: true,
      url: process.env.REACT_APP_BACKEND_URL + "/camera/start",
    }).then(async (res) => {
      console.log("********************");
    });

    if (captueBtn === "Start Capture") {
      setCaptureBtn("End Capture");
    }
    else {
      setNewDatasetBtn(true);
      setCaptureBtn("Start Capture");
    }   
  }; 

  const onGpsBtnClick = () => {
    Axios({
      method: "GET",
      withCredentials: true,
      url: process.env.REACT_APP_BACKEND_URL + "/gps/start",
    }).then(async (res) => {
      console.log("********************");
    });

    if (gpsBtn === "Start Gps"){
    setGpsBtn("End Gps");
    } 
    else {
      setGpsBtn("Start Gps");
    }
  };


  const onImuBtnClick = () => {
    Axios({
      method: "GET",
      withCredentials: true,
      url: process.env.REACT_APP_BACKEND_URL + "/imu/start",
    }).then(async (res) => {
      console.log("********************");
    });

    if (imuBtn === "Start Imu") 
    {
      setImuBtn("End Imu");
    }
    else {
      setImuBtn("Start Imu");
    }
  };


  return (
    <React.Fragment>
      <div className=" row  m-1 ">
        <div className="col-6 px-1  my-1">
          <button
            disabled={!newDatasetBtn}
            className="btn btn-primary btn-block"
            onClick={onNewDataSet}
          >
            New Dataset 
          </button>
        </div>
        <div className="col-6 px-1 my-1">{datasetName}</div>
        <div className="col-6 px-1 my-1">
          <button
            className="btn btn-primary btn-block"
            disabled={newDatasetBtn}
            onClick={onGpsBtnClick}
          >
            {gpsBtn}
          </button>
        </div>
        <div className="col-6 px-1 my-1">
          <button
            className="btn btn-primary btn-block"
            disabled={newDatasetBtn}
            onClick={onImuBtnClick}
          >
           {imuBtn}
          </button>
        </div>

        <div className="col-12 px-1 my-1">
          <button
            className="btn btn-primary btn-block"
            disabled={newDatasetBtn}
            onClick={onCaptureBtnClick}
          >
            {captueBtn}
          </button>
        </div>
      </div>
    </React.Fragment>
  );
};
export default GeneralStatus;
