import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import {
  faBatteryFull,
  faBatteryQuarter,
  faLink,
  faSdCard,
  faUnlink,
} from "@fortawesome/free-solid-svg-icons";
import "./Camera.css";
const Camera = (props) => {
  return (
    <div className={"border border-dark p-1 rounded " + ( props.connected === 0 ? "" : "border-thick") }>
      <div className={props.bat < 20 ? " text-danger" : ""}>
        <div className="col-3 float-left text-right">
          <FontAwesomeIcon
            icon={props.bat < 20 ? faBatteryQuarter : faBatteryFull}
            className="menu-icon "
          />
        </div>
        <span className={props.bat < 20 ? " p-1 text-danger small" : "p-1 small"}>
          {props.bat}%
        </span>
      </div>
      <div className={props.connection ?  "text-success" :" text-danger"}>
        <div className="col-3 float-left text-right">
          <FontAwesomeIcon icon={props.connection ? faLink : faUnlink} className="menu-icon" />
        </div>
        <span className={ props.recording ? "flash small" :" small"}>{props.name}</span>
      </div>
      <div className={props.sd < 60 ? "m-2  text-danger" : "m-2 "}>
        <div className="col-3 float-left text-right">
          <FontAwesomeIcon icon={faSdCard} className="menu-icon" />
        </div>
        <span className="p-1 small">
          {Math.floor(props.sd / 60)}:{Math.floor(props.sd % 60)}
        </span>
      </div>
    </div>
  );
};
export default Camera;
