import React, { useState } from "react";
import Axios from "axios";

const GeneralStatus = () => {
  const [newDatasetBtn, setNewDatasetBtn] = useState(true);
  const [captueBtn, setCaptureBtn] = useState("Start Capture");
  const [gpsBtn, setGpsBtn] = useState("Start Gps");  
  const [imuBtn, setImuBtn] = useState("Start Imu");    
  const [datasetName, setDatasetName] = useState("dataset 1"); 

  const onNewDataSet = () => {
    Axios({
      method: "GET",
      withCredentials: true,
      url: process.env.REACT_APP_BACKEND_URL + "/dataset/start",
    }).then(async (res) => {
      console.log("********************");
      // update dataset name
      setDatasetName(res.data.dataset_name)

    });

    setNewDatasetBtn(false);
  };

  const onCaptureBtnClick = () => {


    if (captueBtn === "Start Capture") {
      Axios({
        method: "GET",
        withCredentials: true,
        url: process.env.REACT_APP_BACKEND_URL + "/camera/rec",
      }).then(async (res) => {
        console.log("********************");
      });
      setCaptureBtn("End Capture");
    }
    else {
      Axios({
        method: "GET",
        withCredentials: true,
        url: process.env.REACT_APP_BACKEND_URL + "/camera/stop",
      }).then(async (res) => {
        console.log("********************");
      });
      setNewDatasetBtn(true);
      setCaptureBtn("Start Capture");
    }   
  }; 

  const onGpsBtnClick = () => {


    if (gpsBtn === "Start Gps"){
      Axios({
        method: "GET",
        withCredentials: true,
        url: process.env.REACT_APP_BACKEND_URL + "/gps/on",
      }).then(async (res) => {
        console.log("********************");
      });
    setGpsBtn("End Gps");
    } 
    else {
      Axios({
        method: "GET",
        withCredentials: true,
        url: process.env.REACT_APP_BACKEND_URL + "/gps/off",
      }).then(async (res) => {
        console.log("********************");
      });
      setGpsBtn("Start Gps");
    }
  };


  const onImuBtnClick = () => {


    if (imuBtn === "Start Imu") 
    {
      Axios({
        method: "GET",
        withCredentials: true,
        url: process.env.REACT_APP_BACKEND_URL + "/imu/on",
      }).then(async (res) => {
        console.log("imu on ********************");
      });
      setImuBtn("End Imu");
    }
    else {
      Axios({
        method: "GET",
        withCredentials: true,
        url: process.env.REACT_APP_BACKEND_URL + "/imu/off",
      }).then(async (res) => {
        console.log(" imu off ********************");
      });
      setImuBtn("Start Imu");
    }
  };


  return (
    <React.Fragment>
      <div className=" row  m-1 ">
        <div className="col-6 px-1  my-1">
          <button
            disabled={!newDatasetBtn}
            className="btn btn-primary btn-block"
            onClick={onNewDataSet}
          >
            New Dataset 
          </button>
        </div>
        <div className="col-6 px-1 my-1">{datasetName}</div>
        <div className="col-6 px-1 my-1">
          <button
            className="btn btn-primary btn-block"
            disabled={newDatasetBtn}
            onClick={onGpsBtnClick}
          >
            {gpsBtn}
          </button>
        </div>
        <div className="col-6 px-1 my-1">
          <button
            className="btn btn-primary btn-block"
            disabled={newDatasetBtn}
            onClick={onImuBtnClick}
          >
           {imuBtn}
          </button>
        </div>

        <div className="col-12 px-1 my-1">
          <button
            className="btn btn-primary btn-block"
            disabled={newDatasetBtn}
            onClick={onCaptureBtnClick}
          >
            {captueBtn}
          </button>
        </div>
      </div>
    </React.Fragment>
  );
};
export default GeneralStatus;
