import React , {useState} from "react";
import "./App.css";
import Cameras from "./components/Cameras";
import ImuGps from "./components/ImuGps";
import {  useEffect } from "react";
import DebugList from"./components/DebugList";
import GeneralStatus from "./components/GeneralStatus";
import DeviceStart from "./components/DeviceStart";
import socketClient   from "socket.io-client"
import {AutoSizer} from 'react-virtualized';
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import {faPause, faPlay} from "@fortawesome/free-solid-svg-icons";
import Axios from "axios";

const socket = socketClient(process.env.REACT_APP_SOCKET_URL,{transports:['websocket']});
// const socket = socketClient(process.env.REACT_APP_SOCKET_URL);
function App() {
  const [pauseMessages, setPauseMessages] = useState(false);
  useEffect(() => {

    socket.on("connection_start", (res) => {
      Axios({
        method: "GET",
        withCredentials: true,
        url: process.env.REACT_APP_BACKEND_URL + "/Device/status",
      }).then(async (res) => {
        console.log(res);
        // update dataset name
  
      });
      console.log(res);
    })

    socket.on("connect_error", (err) => {
      console.log(`connect_error due to ${err.message}`);
    });
  }, []);

const onPauseMessages =() =>{
  setPauseMessages(!pauseMessages)
}
  return (
    <div className="App pt-3">
      <h4>Backpack GUI</h4>
      <div className=" m-2 py-1 border border-dark  rounded">
        <Cameras  socket={socket} />
        <ImuGps socket={socket} />
        <DeviceStart/>
      </div>
      <div className=" m-2 py-1 border border-dark  rounded">
        <GeneralStatus socket={socket} />
      </div>
      <div className=" m-2 px-2 border border-dark  rounded fill-height text-left relative ">
        <button className="btn btn-light btn-sm fixed-tr" onClick={onPauseMessages} > 
        <FontAwesomeIcon icon={ pauseMessages ? faPlay : faPause } className="menu-icon " />
        </button>
      <AutoSizer>
      {({ width, height }) => (
      <DebugList socket={socket} pause={pauseMessages} width={width} height={height} ></DebugList>
      )}
      </AutoSizer>
      </div>
    </div>
  );
}

export default App;
