import React from "react";
import { List } from "react-virtualized";
class DebugList extends React.Component {
  state = {
    data: [],
  };

  constructor(props) {
    super(props);
  }

  componentDidMount() {
    this.props.socket.on("debugMessages", (res) => {
      // // console.log('2',res)
      //  let db=[]
      // let db=[res,...debugMessages]
      // let dbl=db.map((msg)=>{return msg['id']})
      if (!this.props.pause) {
        let mydata = [res, ...this.state.data];
        this.setState({ data: mydata });
      }
    });
  }

  rowRenderer = ({ index, isScrolling, key, style }) => {
    return (
      <li
        className={"list-group-item " + this.state.data[index].type}
        key={`liMessages_${index}`}
      >
        {this.state.data[index].message}
      </li>
    );
  };

  render() {
    const height = this.props.height;
    const rowHeight = 40;
    const width = this.props.width;
    return (
      <ul className="list-group">
        <List
          rowCount={this.state.data.length}
          width={width}
          height={height - 10}
          rowHeight={20}
          rowRenderer={this.rowRenderer}
          overscanRowCount={3}
        />
      </ul>
    );
  }
}
export default DebugList;
