import React from "react";
import "./App.css";
import Cameras from "./components/Cameras";
import ImuGps from "./components/ImuGps";
import { Card } from "react-bootstrap";
import Axios from "axios";
import { useContext , useEffect , useState} from "react";
import DebugMessages from "./components/DebugMessages";
import DebugList from"./components/DebugList";
import GeneralStatus from "./components/GeneralStatus";
import socketClient   from "socket.io-client"
import {AutoSizer} from 'react-virtualized';

const socket = socketClient("http://192.168.0.98:5000",{transports:['websocket']});
function App() {
  // const [CameraData, setCameraData] = useState({});
  // const [newCameraData , setNewCameraData] = useState({});
  useEffect(() => {

    socket.on("connectionStart", (res) => {
      console.log(res);

    })
    // socket.on("debugMessages", (res) => {
    //   console.log(res);

    // })
    socket.on("connect_error", (err) => {
      console.log(`connect_error due to ${err.message}`);
    });
  //   Axios({
  //     method: "GET",
  //     withCredentials: true,
  //     url:
  //       process.env.REACT_APP_BACKEND_URL +
  //       "/cameraInfo" 
  //   }).then(async (res) => {
  //     console.log("********************")
  //     setCameraData(res)
  //   });
    
  }, []);


  return (
    <div className="App pt-3">
      <h4>Backpack GUI</h4>
      {/* <div className=" m-2 py-1 border border-dark  rounded">
        <Cameras  socket={socket} />
        <ImuGps socket={socket} />
      </div> */}
      <div className=" m-2 py-1 border border-dark  rounded">
        <GeneralStatus socket={socket} />
      </div>
      <div className=" m-2 px-2 border border-dark  rounded fill-height text-left ">
      <AutoSizer>
      {({ width, height }) => (
      <DebugList socket={socket} width={width} height={height} ></DebugList>
      )}
      </AutoSizer>
      </div>
    </div>
  );
}

export default App;
